% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geographies.R
\name{get_statcan_geographies}
\alias{get_statcan_geographies}
\title{Read the geosuite data}
\usage{
get_statcan_geographies(
  census_year,
  level,
  type = "cartographic",
  cache_path = NULL,
  timeout = 1000,
  refresh = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{census_year}{census year to get the data for, right now only 2021 is supported}

\item{level}{geographic level to return the data for, valid choices are
"PR","CD","CMACA","CSD","CT","ADA","DA","ER","FED","DPL","POPCNTR"}

\item{type}{type of geographic data, valid choices area "cartographic" or "digital"}

\item{cache_path}{optional path to cache the data. If the cancensus cache path is set the geographic data gets
cached in the "geographies" subdirectory of the cancensus cache path.}

\item{timeout}{optional timeout parameter, adjust as needed if the data download times out when using slow connections}

\item{refresh}{(logical) refresh the cache if true}

\item{quiet}{(logical) suppress messages if `TRUE`}
}
\value{
a spatial dataframe with the geographic data
}
\description{
Reads the original unprocessed geographic boundary files from Statistics Canada
}
\examples{
# get the digital geographic boundaries for provinces and territories
\dontrun{
get_statcan_geographies(census_year="2021",level="PR",type="digital")
}
}
