% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_organisation_units_metadata.R
\name{get_organisation_units_metadata}
\alias{get_organisation_units_metadata}
\title{Get Organisation Units Metadata}
\usage{
get_organisation_units_metadata(...)
}
\arguments{
\item{...}{Options that can be passed onto KHIS API.}
}
\value{
A tibble containing the following columns:
\itemize{
\item facility_id   - Organisation identifier that uniquely identifies the health facility.
\item ward_id       - Organisation identifier that uniquely identifies the ward.
\item subcounty_id  - Organisation identifier that uniquely identifies the subcounty.
\item county_id     - Organisation identifier that uniquely identifies the county.
\item facility      - Name of the health facility.
\item county        - Name of the county.
\item subcounty     - Name of the subcounty.
\item ward          - Name of the ward.
}
}
\description{
\code{\link[=get_organisation_units_metadata]{get_organisation_units_metadata()}} fetches organisation units metadata from the
KHIS API server.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Fetch all the organisation units metadata
organisations <- get_organisation_units_metadata()
organisations
\dontshow{\}) # examplesIf}
}
