% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_sql.R
\name{get_cansim_sqlite}
\alias{get_cansim_sqlite}
\title{Retrieve a Statistics Canada data table using NDM catalogue number as SQLite database connection}
\usage{
get_cansim_sqlite(
  cansimTableNumber,
  language = "english",
  refresh = FALSE,
  timeout = 1000,
  cache_path = getOption("cansim.cache_path")
)
}
\arguments{
\item{cansimTableNumber}{the NDM table number to load}

\item{language}{\code{"en"} or \code{"english"} for English and \code{"fr"} or \code{"french"} for French language versions (defaults to English)}

\item{refresh}{(Optional) When set to \code{TRUE}, forces a reload of data table (default is \code{FALSE})}

\item{timeout}{(Optional) Timeout in seconds for downloading cansim table to work around scenarios where StatCan servers drop the network connection.}

\item{cache_path}{(Optional) Path to where to cache the table permanently. By default, the data is cached
in the path specified by `getOption("cansim.cache_path")`, if this is set. Otherwise it will use `tempdir()`.}
}
\value{
tibble format data table output with added Date column with inferred date objects and
a "val_norm" column with normalized VALUE using the supplied scale factor
}
\description{
Retrieves a data table using an NDM catalogue number as an SQLite table. Retrieved table data is
cached permanently if a chache path is supplied or for duration of the current R session.
This function is useful for large tables that don't have very often.
}
\examples{
\donttest{
con <- get_cansim_sqlite("34-10-0013")

# Work with the data connection
head(con)

disconnect_cansim_sqlite(con)
}
}
