% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cansim_sql.R
\name{collect_and_normalize}
\alias{collect_and_normalize}
\title{collect data from connection and normalize cansim table output}
\usage{
collect_and_normalize(
  connection,
  replacement_value = "val_norm",
  normalize_percent = TRUE,
  default_month = "07",
  default_day = "01",
  factors = FALSE,
  strip_classification_code = FALSE
)
}
\arguments{
\item{connection}{connection to database}

\item{replacement_value}{(Optional) the name of the column the manipulated value should be returned in. Defaults to adding the `val_norm` value field.}

\item{normalize_percent}{(Optional) When \code{true} (the default) normalizes percentages by changing them to rates}

\item{default_month}{The default month that should be used when creating Date objects for annual data (default set to "01")}

\item{default_day}{The default day of the month that should be used when creating Date objects for monthly data (default set to "01")}

\item{factors}{(Optional) Logical value indicating if dimensions should be converted to factors. (Default set to \code{false}).}

\item{strip_classification_code}{(strip_classification_code) Logical value indicating if classification code should be stripped from names. (Default set to \code{false}).}
}
\value{
a tibble with the normalized data
}
\description{
collect data from connection and normalize cansim table output
}
\examples{
\donttest{
library(dplyr)

con <- get_cansim_sqlite("34-10-0013")
data <- con \%>\%
  filter(GEO=="Ontario") \%>\%
  collect_and_normalize()

disconnect_cansim_sqlite(con)
}
}
