% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten_array.R
\name{flatten_array}
\alias{flatten_array}
\title{Drop the 3rd dimension of an array using a summary 
function, e.g., min max, mean}
\usage{
flatten_array(arrayX, margin1, margin2, slice_fun)
}
\arguments{
\item{arrayX}{3D array of values, effects or t_stats, etc.}

\item{margin1}{dimension that will end up as the columns of the final matrix}

\item{margin2}{dimension that will end up as the rows of the final matrix}

\item{slice_fun}{summary function. The function by which to summarize 
the remaining dimension e.g., \code{function(x) mean(x, na.rm = TRUE)}}
}
\value{
A 2D matrix summarizing the input array
}
\description{
This function takes in a 3D array of values, effects or t_stats, etc.
and returns a 2D matrix in which each entry contains a single value
representing all corresponding entries in the 3rd dimension. This
number is determined by the function specified by the user. It could be min,
max, mean, etc.
}
\keyword{internal}
