% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eigentraits.R
\name{get_eigentraits}
\alias{get_eigentraits}
\title{Calculate eigentraits}
\usage{
get_eigentraits(data_obj, scale_pheno = TRUE, normalize_pheno = TRUE)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{scale_pheno}{A logical value indicating whether to 
mean-center and standardize the traits.}

\item{normalize_pheno}{A logical value indicating whether to 
rankZ normalize the phenotypes.}
}
\value{
Returns the data object with the eigentraits,
singular values, and right singular vectors added.
}
\description{
This function uses singular value decomposition
(SVD) to calculate eigentraits from the phenotype 
matrix in the cape data object. It
adds the eigentrait matrix to the data object
along with the singular values and the right
singular vectors.
}
\details{
If scale_pheno is TRUE, the phenotypes are 
mean-centered and standardized before running
the svd.

Because we use SVD in this step, there can be
no missing values in the phenotype matrix. Any individuals
with missing values are removed with a message.
}
\examples{
\dontrun{
data_obj <- get_eigentraits(data_obj)
}
}
