% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_int_heat.R
\name{plot_int_heat}
\alias{plot_int_heat}
\title{Plot phenotypic effects for two markers as a heat map}
\usage{
plot_int_heat(
  phenoV,
  marker1_vals,
  marker2_vals,
  pheno_name = NULL,
  marker1_label = NULL,
  marker2_label = NULL,
  bins1 = 50,
  bins2 = 50
)
}
\arguments{
\item{phenoV}{A vector of trait values}

\item{marker1_vals}{A vector of genotype values 
for marker1}

\item{marker2_vals}{A vector of genotype values
for marker2.}

\item{pheno_name}{A string indicating the name of
the trait being plotted.}

\item{marker1_label}{A string indicating the name
of marker1}

\item{marker2_label}{A string indicating the name
of marker2}

\item{bins1}{The number of bins for marker1 over 
which to predict values of the trait. This can also 
be a vector specifying those bins.}

\item{bins2}{The number of bins for marker2 over 
which to predict values of the trait. This can also 
be a vector specifying those bins.}
}
\value{
None
}
\description{
This internal function is called by 
\code{\link{plot_effects}} to generate a 
heat map showing the effects of genotype on
phenotype. This function fits linear models
to the markers and traits. It then uses
these models to predict trait values at 
different genotype combinations in a 2D 
grid. It plots these predicted values in
a heat map.
}
\keyword{internal}
