% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motivation_and_confidence.R
\name{get_adequacy_score}
\alias{get_adequacy_score}
\title{Compute an adequacy score.}
\usage{
get_adequacy_score(csappa2 = NA, csappa4 = NA, csappa6 = NA)
}
\arguments{
\item{csappa2}{A numeric (integer) vector representing a response to CSAPPA item 2 (valid values are integers between 1 and 4).}

\item{csappa4}{A numeric (integer) vector representing a response to CSAPPA item 4 (valid values are integers between 1 and 4).}

\item{csappa6}{A numeric (integer) vector representing a response to CSAPPA item 6 (valid values are integers between 1 and 4).}
}
\value{
Returns a numeric vector with values between 1.8 and 7.5 (if valid) or NA (if not valid).
}
\description{
This function computes an adequacy score (\code{adequacy_score}) for responses to items 2, 4 and 6 of the CSAPPA (Children's Self-Perceptions of Adequacy in
and Predilection for Physical Activity; Hay, 1992) Questionnaire as they appear in \href{https://www.capl-eclp.ca/wp-content/uploads/2018/02/CAPL-2-questionnaire.pdf}{the CAPL-2 Questionnaire}. This score is used to compute the motivation
and confidence domain score (\code{mc_score}).
}
\details{
Valid values (integers between 1 and 4) represent the following responses:
\itemize{
\item 1 = REALLY TRUE for me for "some kids" statements
\item 2 = SORT OF TRUE for me for "some kids" statements
\item 3 = REALLY TRUE for me for "other kids" statements
\item 4 = SORT OF TRUE for me for "other kids" statements
}

Other \code{capl} functions called by this function include: \code{\link[=validate_scale]{validate_scale()}}.
}
\examples{
get_adequacy_score(
  csappa2 = c(1:3, 0),
  csappa4 = c(4, 2, 1, "3"),
  csappa6 = c(4, 4, 2, 2)
)

# [1] 4.9 4.8 4.9  NA

}
