% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotImmigrationFlow.R
\name{PlotImmigrationFlow}
\alias{PlotImmigrationFlow}
\title{Plot immigration flows}
\usage{
PlotImmigrationFlow(data = NULL, source = NULL, destination = NULL,
  n.sources = 5, agg.sources.prefix = "Other ",
  agg.sources.suffix = " sources", cls = NULL, start.degree = 0,
  sources.label.dist = 0.15, sources.label.size = 0.75,
  ticks.label.size = 0.7)
}
\arguments{
\item{data}{\code{\link{data.frame}} with sources and destination.}

\item{source}{\code{data}'s column name or index with places' names. Sources' names and destination's name must be in this column.}

\item{destination}{destination's name.}

\item{n.sources}{number of sources to plot. If smaller than the total number of sources \code{source}, the less frequent sources are aggregated.}

\item{agg.sources.prefix}{string. If n.sources is smaller than the total number of sources, \code{agg.sources.prefix} is used to label the aggregated sources.}

\item{agg.sources.suffix}{\code{\link{character}}. If n.sources is smaller than the total number of sources, \code{agg.sources.prefix} is used to label the aggregated sources.}

\item{cls}{Optional \code{\link{character}} \code{\link{vector}} with \code{n.sources} + 1 colors.}

\item{start.degree}{The starting degree from which the circle begins to draw. It is passed to the \code{start.degree} argumento of \code{circlize::circos.par} function.}

\item{sources.label.dist}{Data point on y-axis to separate the sources' labels from the circle. It is passed to the \code{y} argument of \code{circlize::circos.text} function.}

\item{sources.label.size}{Font size for sources' labels. It is passed to the \code{cex} argument of \code{circlize::circos.text} function.}

\item{ticks.label.size}{Font size for sources' labels. It is passed to the \code{labels.cex} argument of \code{circlize::circos.axis} function.}
}
\description{
Plot rimmigration flows from many sources to one destination.
}
\details{
The numbers arround the circle indicate the number of animals.
}
\examples{
data(dogs)
cls <- c("blue3", "orange", "skyblue", "darkgreen", "yellow3", "black")
PlotImmigrationFlow(dogs, "acquisition_city", "Pinhais",
                    cls = cls, agg.sources.suffix = " cities")

}
\references{
Gu, Z. (2014) circlize implements and enhances circular visualization in R. Bioinformatics. DOI: 10.1093/bioinformatics/btu393

Baquero, O. S., Marconcin, S., Rocha, A., & Garcia, R. D. C. M. (2018). Companion animal demography and population management in Pinhais, Brazil. Preventive Veterinary Medicine.

\url{http://oswaldosantos.github.io/capm}
}
