% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carbonate.R
\name{.carbonate}
\alias{.carbonate}
\alias{carbon-carbonate}
\alias{carbonate}
\title{Carbonate script lines to a carbon image}
\usage{
.carbonate(self, private, file, path, code, rD)
}
\arguments{
\item{self}{carbon self object}

\item{private}{carbon private object}

\item{file}{character, name of file to save image as}

\item{path}{character, path to save the image}

\item{code}{character, lines of script to make carbon image from}

\item{rD}{RSelenium driver}
}
\value{
image object
}
\description{
Main function of the package that invokes RSelenium to open
a browser to the carbon.js uri, create an image and download the file.
}
\details{
Script is passed to \url{https://carbon.now.sh/} is downloaded to the \code{tempdir()} and appended to the list \link[carbonate:carbon-fields]{$carbons} using RSelenium and Chrome.
}
\examples{
if(interactive()){
 x <- carbon$new('x <- 1')
 x$carbonate()
 }
}
\seealso{
\link[carbonate:carbon]{carbon}, \link[RSelenium:rsDriver]{rsDriver}
}
