% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent-events.R
\name{recur_followup_table}
\alias{recur_followup_table}
\title{Initial and Final Visit Table}
\usage{
recur_followup_table(data, studyid, keyid, date)
}
\arguments{
\item{data}{Data frame containing all clinical covariates of interest}

\item{studyid}{Should be one ID for every study date/visit. Can have
multiples ONLY if there were several data points gathered on a single visit
(e.g. heart rate measured multiple times on the same day).}

\item{keyid}{Should be the ID that corresponds to each studyid throughout
each visit}

\item{date}{Name of column containing the date of each visit}
}
\value{
Returns list of initial and most recent data sets. These can easily
be merged after with any naming nomenclature as chosen, or with any merging
keys as chosen (in case there are several merging variables, like keyid +
hour of day for circadian data).
}
\description{
Makes a before/after dataset using a unique ID that follows
patients between studies, to allow for comparison over time.
}
\details{
Currently functions by taking two input IDs, one being a ID that is
the same between studies (a true key ID) and an ID that is unique to that
study itself. It will arrange by dates, and and slice data into an initial
visit and the most recent visit. Each row should have a KEY ID and a STUDY
ID. The data is in a long format, such that the STUDY IDs are unique / not
duplicated.
}
