% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_ard_structure.R
\name{check_ard_structure}
\alias{check_ard_structure}
\title{Check ARD Structure}
\usage{
check_ard_structure(x, column_order = TRUE, method = TRUE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}

\item{column_order}{(scalar \code{logical})\cr
check whether ordering of columns adheres to to \code{cards::tidy_ard_column_order()}.}

\item{method}{(scalar \code{logical})\cr
check whether a \code{"stat_name"} equal to \code{"method"} appears in results.}
}
\value{
an ARD data frame of class 'card' (invisible)
}
\description{
Function tests the structure and returns notes when object does not
conform to expected structure.
}
\examples{
ard_continuous(ADSL, variables = "AGE") |>
  dplyr::select(-warning, -error) |>
  check_ard_structure()
}
