% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_continuous_ci.survey.design.R
\name{ard_continuous_ci.survey.design}
\alias{ard_continuous_ci.survey.design}
\title{ARD survey continuous CIs}
\usage{
\method{ard_continuous_ci}{survey.design}(
  data,
  variables,
  by = NULL,
  method = c("svymean", "svymedian.mean", "svymedian.beta", "svymedian.xlogit",
    "svymedian.asin", "svymedian.score"),
  conf.level = 0.95,
  df = survey::degf(data),
  ...
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are calculated for \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.}

\item{method}{(\code{string})\cr
Method for confidence interval calculation.
When \code{"svymean"}, the calculation is computed via \code{survey::svymean()}.
Otherwise, it is calculated via\code{survey::svyquantile(interval.type=method)}}

\item{conf.level}{(scalar \code{numeric})\cr
confidence level for confidence interval. Default is \code{0.95}.}

\item{df}{(\code{numeric})\cr
denominator degrees of freedom, passed to \code{survey::confint(df)}.
Default is \code{survey::degf(data)}.}

\item{...}{arguments passed to \code{survey::confint()}}
}
\value{
ARD data frame
}
\description{
One-sample confidence intervals for continuous variables' means and medians.
Confidence limits are calculated with \code{survey::svymean()} and \code{survey::svyquantile()}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "survey"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
dclus1 <- survey::svydesign(id = ~dnum, weights = ~pw, data = apiclus1, fpc = ~fpc)

ard_continuous_ci(dclus1, variables = api00)
ard_continuous_ci(dclus1, variables = api00, method = "svymedian.xlogit")
\dontshow{\}) # examplesIf}
}
