\name{bagFDA}
\alias{bagFDA}
\alias{print.bagFDA}
\alias{bagFDA.default}
\alias{bagFDA.formula}

\title{Bagged FDA}

\description{A bagging wrapper for flexible discriminant analysis (FDA) using multivariate adaptive regression splines (MARS) basis functions} 


\usage{
bagFDA(x, ...)
\method{bagFDA}{formula}(formula, data = NULL, B = 50, keepX = TRUE,
   ..., subset, weights, na.action = na.omit)
\method{bagFDA}{default}(x, y, weights = NULL, B = 50, keepX = TRUE, ...)
}

\arguments{

  \item{formula}{A formula of the form 'y ~ x1 + x2 + ...' }

  \item{x}{matrix or data frame of 'x' values for examples.} 

  \item{y}{matrix or data frame of numeric values outcomes. }

  \item{weights}{(case) weights for each example - if missing defaults to 1.} 

  \item{data}{Data frame from which variables specified in  'formula' are
          preferentially to be taken. }
  \item{subset}{An index vector specifying the cases to be used in the
          training sample.  (NOTE: If given, this argument must be
          named.) }
  \item{na.action}{A function to specify the action to be taken if 'NA's are
          found. The default action is for the procedure to fail.  An
          alternative is na.omit, which leads to rejection of cases
          with missing values on any required variable.  (NOTE: If
          given, this argument must be named.) }
   
  \item{B}{the numebr of bootstrap samples }  
  
  \item{keepX}{a logical: should the original training data be kept?}  
  
  \item{\dots}{arguments passed to the \code{mars} function}
  
}

\details{The function computes a FDA model for each bootstap sample.}

\value{
A list with elements
  \item{fit }{a list of \code{B} FDA fits}
  \item{B }{the number of bootstrap samples}
  \item{call }{the function call}
  \item{x }{either \code{NULL} or the value of \code{x}, depending on the 
    value of \code{keepX}}
  \item{oob}{a matrix of performance estimates for each bootstrap sample}  
}

\references{J. Friedman, ``Multivariate Adaptive Regression Splines'' (with
     discussion) (1991).  Annals of Statistics, 19/1, 1-141.}
     
\author{Max Kuhn (\code{bagFDA.formula} is based on Ripley's \code{nnet.formula})}

\seealso{\code{\link[mda]{fda}}, \code{\link{predict.bagFDA}}}

\examples{
library(mlbench)
library(earth)
data(Glass)

set.seed(36)
inTrain <- sample(1:dim(Glass)[1], 150)

trainData <- Glass[ inTrain, ]
testData  <- Glass[-inTrain, ]


baggedFit <- bagFDA(Type ~ ., trainData)
baggedMat <- table(
   predict(baggedFit, testData[, -10]),
   testData[, 10])
   
print(baggedMat)

classAgreement(baggedMat)
}

\keyword{regression}

