\name{filterVarImp}

\alias{filterVarImp}

\title{Calculation of filter-based variable importance }

\description{ 
Specific engines for variable importance on a model by model basis.
}

\usage{
filterVarImp(x, y, nonpara = FALSE, ...) 
}

\arguments{
  \item{x}{A matrix or data frame of predictor data}
  \item{y}{A vector (numeric or factor) of outcomes)}
  \item{nonpara}{should nonparametric methods be used to assess the relationship
  between the features and response}  
  \item{...}{options to pass to either \code{\link[stats]{lm}} or \code{\link[stats]{loess}}}
  
}

\value{
   A data frame with variable importances. Column names depend on the problem type.
   For regression, the data frame contains one column: "Overall" for the importance
   values.
   
}


\details{


The importance of each predictor is evaluated individually using a ``filter'' approach. 

For classification, ROC curve analysis is conducted on each predictor. For two class problems, a series of cutoffs is applied to the predictor data to predict the class. The sensitivity and specificity are computed for each cutoff and the ROC curve is computed. The trapezoidal rule is used to compute the area under the ROC curve. This area is used as the measure of variable importance. For multi--class outcomes, the problem is decomposed into all pair-wise problems and the area under the curve is calculated for each class pair (i.e class 1 vs. class 2, class 2 vs. class 3 etc.). For a specific class, the maximum area under the curve across the relevant pair--wise AUC's is used as the variable importance measure.

For regression, the relationship between each predictor and the outcome is evaluated. An argument, \code{nonpara}, is used to pick the model fitting technique. When \code{nonpara = FALSE}, a linear model is fit and the absolute value of the $t$--value for the slope of the predictor is used. Otherwise, a loess smoother is fit between the outcome and the predictor. The $R^2$ statistic is calculated for this model against the intercept only null model.

}

\author{Max Kuhn}

\examples{
data(mdrr)
filterVarImp(mdrrDescr[, 1:5], mdrrClass)

data(BloodBrain)

filterVarImp(bbbDescr[, 1:5], logBBB, nonpara = FALSE)
apply(
      bbbDescr[, 1:5],
      2,
      function(x, y) summary(lm(y~x))$coefficients[2,3],
      y = logBBB)

filterVarImp(bbbDescr[, 1:5], logBBB, nonpara = TRUE)
}

\keyword{ models }
