% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel.needle.R
\name{panel.needle}
\alias{panel.needle}
\title{Needle Plot Lattice Panel}
\usage{
panel.needle(x, y, horizontal = TRUE, pch = if (is.null(groups))
  dot.symbol$pch else sup.symbol$pch, col = if (is.null(groups))
  dot.symbol$col else sup.symbol$col, lty = dot.line$lty,
  lwd = dot.line$lwd, col.line = dot.line$col, levels.fos = NULL,
  groups = NULL, ...)
}
\arguments{
\item{x, y}{variables to be plotted in the panel. Typically y is the 'factor'}

\item{horizontal}{logical. If FALSE, the plot is `transposed' in the sense
that the behaviours of x and y are switched. x is now the `factor'.
Interpretation of other arguments change accordingly. See documentation of
\code{bwplot} for a fuller explanation.}

\item{pch, col, lty, lwd, col.line}{graphical parameters}

\item{levels.fos}{locations where reference lines will be drawn}

\item{groups}{grouping variable (affects graphical parameters)}

\item{\dots}{extra parameters, passed to \code{panel.xyplot} which is
responsible for drawing the foreground points (\code{panel.dotplot} only
draws the background reference lines).}
}
\description{
A variation of \code{panel.dotplot} that plots horizontal lines from zero to
the data point.
}
\details{
Creates (possibly grouped) needleplot of \code{x} against \code{y} or vice
versa
}
\author{
Max Kuhn, based on \code{\link[lattice]{panel.dotplot}} by Deepayan
Sarkar
}
\seealso{
\code{\link{dotplot}}
}
\keyword{graphs}

