% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barscale.R
\name{barscale}
\alias{barscale}
\title{Scale Bar}
\usage{
barscale(size, lwd = 1.5, cex = 0.6, pos = "bottomright", style = "pretty")
}
\arguments{
\item{size}{size of the scale bar in kilometers. If size is not set, an 
automatic size is used (1/10 of the map width).}

\item{lwd}{width of the scale bar.}

\item{cex}{cex of the text.}

\item{pos}{position of the legend, default to "bottomright". 
"bottomright" or a vector of two coordinates (c(x, y)) are possible.}

\item{style}{style of the legend, either "pretty" or "oldschool". The 
"oldschool" style only uses the "size" parameter.}
}
\description{
Plot a scale bar.
}
\note{
This scale bar is not accurate on unprojected (long/lat) maps.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq), col = "grey60", border = "grey20")
barscale(size = 5)
barscale(size = 5, lwd = 2, cex = .9, pos = c(714000, 1596000))
}
\seealso{
\link{layoutLayer}
}
