% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brktrials3setup.R
\name{brktrials3setup}
\alias{brktrials3setup}
\title{\code{brktrials3setup} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck}
\usage{
brktrials3setup(nveh, umn, usd, tstart, tend, xstart, step, type, leff)
}
\arguments{
\item{nveh}{number of vehicles entering the bottleneck, a number}

\item{umn}{start speed (mph) for vehicle in lane 1, a number}

\item{usd}{speed volatility for \code{umn}, a number}

\item{tstart}{start time, (seconds), a number}

\item{tend}{end time, (seconds), a number}

\item{xstart}{start location, (feet), a number}

\item{step}{size in seconds, a number}

\item{type}{TRUE or FALSE, a logical}

\item{leff}{vehicle length in feet, a number}
}
\value{
\code{brktrials3setup} returns  \code{t-x} trajectories of \code{nveh} vehicles at a bottleneck.
}
\description{
\code{brktrials3setup} produces \code{t-x} trajectories for lead and following vehicles at a bottleneck
}
\examples{
brktrials3setup(5, 68.4, 4.4, 0, 30, -700, 0.25, FALSE, 14)
}
