% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carx_plots.R
\name{tsdiag.carx}
\alias{tsdiag.carx}
\title{Show diagnostic plots for a \code{carx} object}
\usage{
\method{tsdiag}{carx}(object, gof.lag, col = "red", omit.initial = TRUE,
  mfrow = c(4, 1), main = "Diagnostic Plots", ...)
}
\arguments{
\item{object}{a \code{carx} object.}

\item{gof.lag}{the maximum number of lags in ACF and Ljung-Box goodness-of-fit test.}

\item{col}{color of some warning lines in the figures, default=\code{red}.}

\item{omit.initial}{whether initial residuals should be omitted, default = \code{TRUE}.}

\item{mfrow}{\code{par} parameter indicating how the plots are to be arranged, default = \code{c(4,1)}.}

\item{main}{The main title of the plot, default = "Diagnostic Plots".}

\item{...}{Other arguments sent to \code{plot}.}
}
\value{
none.
}
\description{
Four diagnostic plots will be shown, which are
\itemize{
\item{the time series plot of the residuals,}
\item{the residuals versus the fitted values,}
\item{the ACF plot of the residuals, and }
\item{the Ljung-Box test statistics versus the lags.}
}
}
\examples{
dat = carxSim(nObs=100,seed=0)
mdl <- carx(y~X1+X2-1,data=dat, p=2, CI.compute = FALSE)
tsdiag(mdl)
}

