% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{copulaFitPlot}
\alias{copulaFitPlot}
\alias{copulaFitPlot,CopulaObj-method}
\alias{copulaFitPlot,ANY-method}
\title{Visualization Copula fitting}
\usage{
copulaFitPlot(object, ...)

\S4method{copulaFitPlot}{CopulaObj}(object)
}
\arguments{
\item{object}{Copula Object}

\item{...}{Additional parameters that may or may not be used}
}
\description{
Visualization Copula fitting
}
\examples{
library(cascsim)
#Prepare pseudo observation data
library(copula)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
dist3<-new("Lognormal",p1=2,p2=1,min=0,max=100,truncated=TRUE)
normal.cop <- normalCopula(c(0.6, 0.36, 0.6), dim=3, dispstr="un")
x <- rCopula(1000, normal.cop)
x[,1]<-Quantile(dist1,x[,1])
x[,2]<-Quantile(dist2,x[,2])
x[,3]<-Quantile(dist3,x[,3])
#Create Copula Object and Fit it to observation data without goodness of fit test
nom.cop <- new("CopulaObj", param=c(0.5,0.5,0.5),marginal=list(dist1=dist1,dist2=dist2,dist3=dist3),
dimension=3,observation=x,fittest=FALSE)
nom.cop <- copulaFit(nom.cop)
copulaFitPlot(nom.cop)
#Create Copula Object and Fit it to observation data with goodness of fit test
clayton.cop <- claytonCopula(c(3), dim=2)
x <- rCopula(1000, clayton.cop)
x[,1]<-Quantile(dist1,x[,1])
x[,2]<-Quantile(dist2,x[,2])
cla.cop <- new("CopulaObj", type="clayton",param=c(3),marginal=list(dist1=dist1,dist2=dist2),
dimension=2,observation=x,fittest=TRUE)
cla.cop <- copulaFit(cla.cop)
copulaFitPlot(cla.cop)
}
