% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_data_lfc.R
\name{draw_data_lfc}
\alias{draw_data_lfc}
\title{Generate binary data (LFC model)}
\usage{
draw_data_lfc(
  n = 100,
  prev = c(0.5, 0.5),
  random = FALSE,
  m = 10,
  se = 0.8,
  sp = 0.8,
  B = round(m/2),
  L = 1,
  Rse = diag(rep(1, m)),
  Rsp = diag(rep(1, m)),
  modnames = paste0("model", 1:m),
  ...
)
}
\arguments{
\item{n}{integer, total sample size}

\item{prev}{numeric, disease and healthy prevalence (adds up to 1)}

\item{random}{logical, random sampling (TRUE) or fixed prevalence (FALSE)}

\item{m}{integer, number of models}

\item{se}{numeric, sensitivity (length 1)}

\item{sp}{numeric, specificity (length 1)}

\item{B}{integer, between 1 and m, specifies how many sensitivity values are projected to 1}

\item{L}{numeric, worst alternative is computed under side condition Acc <= L
(default value L=1 corresponds to true LFC where values are projected to 1)}

\item{Rse}{matrix, correlation matrix for empirical sensitivities (m x m)}

\item{Rsp}{matrix, correlation matrix for empirical specificities (m x m)}

\item{modnames}{character, model names (length m)}

\item{...}{further arguments (currently unused)}
}
\value{
Generated binary dataset
}
\description{
Generate binary data (LFC model)
}
\examples{
data <- draw_data_lfc()
head(data)
}
