% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_outlying}
\alias{sc_outlying}
\alias{sc_outlying.default}
\alias{sc_outlying.scree}
\alias{sc_outlying.igraph}
\title{Compute outlying scagnostic measure using MST}
\usage{
sc_outlying(x, y)

\method{sc_outlying}{default}(x, y)

\method{sc_outlying}{scree}(x, y = NULL)

\method{sc_outlying}{igraph}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's outlying score.
}
\description{
Compute outlying scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  ggplot(datasaurus_dozen, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~dataset, ncol=3, scales = "free")
  sc_outlying(datasaurus_dozen_wide$dino_x, datasaurus_dozen_wide$dino_y)
  sc_outlying(datasaurus_dozen_wide$dots_x, datasaurus_dozen_wide$dots_y)
  sc_outlying(datasaurus_dozen_wide$h_lines_x, datasaurus_dozen_wide$h_lines_y)

}
