% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphahull.R
\name{sc_skinny}
\alias{sc_skinny}
\alias{sc_skinny.default}
\alias{sc_skinny.scree}
\alias{sc_skinny.list}
\title{Compute skinny scagnostic measure}
\usage{
sc_skinny(x, y)

\method{sc_skinny}{default}(x, y)

\method{sc_skinny}{scree}(x, y = NULL)

\method{sc_skinny}{list}(x, y = NULL)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's skinny score.
}
\description{
Compute skinny scagnostic measure
}
\examples{
  require(ggplot2)
  require(dplyr)
  ggplot(features, aes(x=x, y=y)) +
     geom_point() +
     facet_wrap(~feature, ncol = 5, scales = "free")
  features \%>\% group_by(feature) \%>\% summarise(skinny = sc_skinny(x,y))
  sc_skinny(datasaurus_dozen_wide$away_x, datasaurus_dozen_wide$away_y)
}
