% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat2cat_utils.R
\name{prune_c2c}
\alias{prune_c2c}
\title{A set of prune methods which will be useful after transition process}
\usage{
prune_c2c(
  df,
  index = "index_c2c",
  column = "wei_freq_c2c",
  method = "nonzero",
  percent = 50
)
}
\arguments{
\item{df}{data.frame}

\item{index}{character default wei_freq_c2c}

\item{column}{character default index_c2c}

\item{method}{character one of four available methods: default "nonzero", "highest", "highest1", "morethan"}

\item{percent}{integer from 0 to 99}
}
\value{
data.frame
}
\description{
user could specify one from four methods to prune replications
}
\details{
method - specify method to reduce number of replications
\itemize{
 \item{"nonzero"}{ remove nonzero probabilities}
 \item{"highest"} { leave only highest probabilities for each subject- accepting ties}
 \item{"highest1"} { leave only highest probabilities for each subject- not accepting ties so always one is returned}
 \item{"morethan"}{ leave rows where a probability is higher than value specify by percent argument }
}
}
\examples{
\dontrun{
data(occup_small)
data(occup)
data(trans)

occup_old <- occup_small[occup_small$year == 2008, ]
occup_new <- occup_small[occup_small$year == 2010, ]

occup_ml <- cat2cat(
  data = list(old = occup_old, new = occup_new, cat_var = "code", time_var = "year"),
  mappings = list(trans = trans, direction = "backward"),
  ml = list(
    data = occup_new,
    cat_var = "code",
    method = "knn",
    features = c("age", "sex", "edu", "exp", "parttime", "salary"),
    args = list(k = 10)
  )
)

prune_c2c(occup_ml$old, method = "nonzero")
prune_c2c(occup_ml$old, method = "highest")
prune_c2c(occup_ml$old, method = "highest1")
prune_c2c(occup_ml$old, method = "morethan", percent = 90)

prune_c2c(occup_ml$old, column = "wei_knn_c2c", method = "nonzero")
}

}
