\name{lr.test}
\alias{lr.test}
\title{LR test of nested models.}
\description{
Given two model objects estimated with a logLik() solution, the function computes an LR test. The order of models, in terms of full or reduced, does not matter.
Supported models include OLS regression via lm, logistic regression via glm, Poisson regression via glm, negative binomial regression via MASS:glm.nb, ordinal logistic regression via MASS::polr, partial proportional odds models via vgam::vglm, multinomial logistic regression via nnet::multinom, zero-inflated Poisson or negative binomial regression via pscl::zeroinfl, and hurdle Poisson or negative binomial regression via pscl::hurdle. For mixed models, use base R's anova function.
}
\usage{
lr.test(full.model,reduced.model)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{full.model}{A model object with unconstrained parameters. The order does not matter however.}
  \item{reduced.model}{A model object with constrained parameters. The order does not matter however.}
}
\value{
  \item{LL Full}{The solution to the log-likelihood function of the full model.}
  \item{LL Reduced}{The solution to the log-likelihood function of the reduced model.}
  \item{G2/LR Statistic}{The test statistic. Computed as -2 x (ll(Full) - ll(Reduced).}
  \item{DF}{The DF for the test. The number of parameters constrained to zero in the reduced model.}
  \item{p-value}{The p-value associated with the LR test. The null hypothesis is that the constrained parameters are jointly equal to zero.}
}
\author{
David Melamed
}
\examples{
data("Mize19AH")
m1 <- glm(alcB ~woman*parrole + age +
race2 + race3 + race4 + income + ed1 + ed2 + ed3 +
ed4,family="binomial",data=Mize19AH)
m0 <- glm(alcB ~woman + parrole + age +
race2 + race3 + race4 + income + ed1 + ed2 + ed3 +
ed4,family="binomial",data=Mize19AH)
lr.test(m1,m0)
lr.test(m0,m1) # Same Result
}
