% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHolder.R
\name{df2dataHolder}
\alias{df2dataHolder}
\title{df2dataHolder}
\usage{
df2dataHolder(
  treatment.formula,
  outcome.formula = NA_character_,
  data,
  weights = NA_real_
)
}
\arguments{
\item{treatment.formula}{a formula specifying the treatment indicator and covariates. Required.}

\item{outcome.formula}{an optional formula specifying the outcome function.}

\item{data}{a data.frame with the data}

\item{weights}{optional vector of sampling weights for the data}
}
\value{
Returns an object of class \code{\link[=dataHolder]{dataHolder()}}
}
\description{
Function to turn a data.frame into a dataHolder object.
}
\details{
This will take the formulas specified and transform that data.frame into a dataHolder object that is used internally by the causalOT package. Take care if you do not specify an outcome formula that you do not include the outcome in the data.frame. If you are not careful, the function may include the outcome as a covariate, which is not kosher in causal inference during the design phase.

If both outcome.formula and treatment.formula are specified, it will assume you are in the design phase, and create a combined covariate matrix to balance on the assumed treatment and outcome models.

If you are in the outcome phase of estimation, you can just provide a dummy formula for the treatment.formula like "z ~ 0" just so the function can identify the treatment indicator appropriately in the data creation phase.
}
\examples{

set.seed(20348)
n <- 15
d <- 3
x <- matrix(stats::rnorm(n*d), n, d)
z <- rbinom(n, 1, prob = 0.5)
y <- rnorm(n)
weights <- rep(1/n,n)
df <- data.frame(x, z, y)
dh <- df2dataHolder(
  treatment.formula = "z ~ .",
  outcome.formula = "y ~ ." ,
  data = df,
  weights = weights)
}
