\name{cslseModel}
\alias{cslseModel}
\alias{slseModel}
\title{
Semiparametric Least Squares Estimator Model
}
\description{
  
This function creates an object of class \code{cslseModel} or
\code{slseModel}. The former is a list of \code{slseModel} objects, one
for each treatment group. The model objects contain all specifications
about the model being estimated including the starting knots used to
construct the basis functions.

}
\usage{
cslseModel(form, data, nbasis = function(n) n^0.3, 
           knots, groupInd=c(treated=1, nontreated=0))
slseModel(form, data, nbasis = function(n) n^0.3, 
           knots)
}
\arguments{
  \item{form}{A formula for the regression in  the case of a simple spline
    regression, or two formulas separated by \code{|}, one for the
    outcome versus the treatment indicator and one of the
    confounders. See the details and examples below.} 
  \item{data}{A \code{data.frame} that contains all variables included
    in \code{form}.} 
  \item{nbasis}{A function to determined the number of basis
    functions. It has to be a function of one argument, the sample
    size.} 
  \item{knots}{An optional list of knots. For \code{cslseModel}, it must 
    be a named list using the group names (treated and nontreated). Each element  
    of the list is also a list  of length  equal to the number of
    covariates. The choice for each covariate is NULL for no knots or
    a numeric vector for specific knots. If missing, the knots are 
    automatically generated.}
  \item{groupInd}{A named vector with the group names and values. By
    default, the treatment indicator defined in \code{form} is equal to
    1 for the treated and 0 for the nontreated. For now, these are
    the only allowed names, but the values can differ. In particular,
    the treatment indicator may be a factor with character values. See
    the example below.}
}  

\details{

An object of class \code{slseModel} is a regression model with a
dependent variable and a set of covariates. We assume that the model can
be written as \eqn{Y=f(X)+e}{Y=f(X)+e}, where \eqn{f(x)}{f(x)} is an
unknown function of the covariates that we approximate using linear
combinations of basis functions. For now, we only consider local linear 
splines defined by sets of knots, one for each covariate generated by
the \code{\link{model.matrix}} of \code{form}. The knots are
automatically determined unless specified by the user. 

An object of class \code{cslseModel} is a list of \code{slseModel}
objects, one for each treatment group. The assignment to a group is
determined by a treatment indicator, which is the right-hand side
variable in the formula to the left of \code{|} specified in
\code{form}. The formula to the right of \code{|} is used by
\code{\link{model.matrix}} to generate a set of confounders for each
treatment group. See the example below and the vignette to more details.

}

\value{

The function \code{slseModel} creates a semiparametric least squares
model or a class \code{slseModel} object. It is a list with the
following elements:

\item{slseForm}{The formula for the semiparametric estimation. It links
  the outcome variable with the matrix of basis functions.}

\item{form}{The \code{form} argument passed to the function
  \code{slseModel}.}

\item{nameY}{The name of the variable representing the outcome}

\item{data}{The dataset passed to the function \code{slseModel} with the
  missing values, if any, omitted.}

\item{knots}{An object of class \code{\link{slseKnots}}. It is the set of
  knots that define the local linear splines.}

\item{nameX}{The names of all covariates included in the model. They are
  all variables implied by the formula \code{form}, which may include
  interactions and functions of variables.}

\item{nameS}{The prefix added to the covariate names when the basis
  functions are generated. By default, it is equal to \code{"U."}}

\item{xlevels}{When relevant, a list of levels of the factors included
  in the model.}

\item{na}{A vector of integer representing the observations omitted
because of missing values. It is \code{NULL} when there are no missing
values.} 

Note that other elements may be present if a knots selection has been
applied to the model.

The function \code{cslseModel} creates an object of class
\code{cslseModel}. It is a list of \code{slseModel} objects, one for
each treatment group. It also contains the following additional
attributes:

\item{treatedVar}{The name of the variable in the dataset that represents
  the treatment indicator.}

\item{groupInd}{A named vector with the value of the treatment indicator
corresponding do each treatment group.}

}

\seealso{\code{\link{selSLSE}} for additional elements that can be
  included in the \code{slseModel} object, \code{\link{estSLSE}} to see
  how the model is estimated and \code{\link{slseKnots}} for the format
  of the knots}

\examples{
data(simDat3)

## Y is the outcome and Z the treatment indicator
## The confounders are X1, X2 and X1:X2:

mod1 <- cslseModel(Y ~ Z | ~ X1 * X2, data = simDat3)
mod1

## A simple SLSE for a regression model

mod2 <- slseModel(Y ~ X1 * X2, data = simDat3)
mod2

## If the treatment indicator differs from 0-1

data(simDat4)
mod3 <- cslseModel(Y ~ treat | ~ X1 * X2, data = simDat4,
                   groupInd = c(treated = "treat", nontreated = "notreat" ))
mod3
}

\keyword{causal effects}
