% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/wtrg_est.R
\name{wtrg_est}
\alias{wtrg_est}
\title{The weighted regression method}
\usage{
wtrg_est(Y,
         treat,
         covar_formula,
         data,
         e_treat_1,
         e_treat_2,
         e_treat_3,
         e_treat_4,
         degree)
}
\arguments{
\item{Y}{is the output}

\item{treat}{is the treatment variable}

\item{covar_formula}{is the formula for the covariates model of the form: ~ X.1 + ....}

\item{data}{will contain all the data: X, treat, and Y}

\item{e_treat_1}{is estimated treatment}

\item{e_treat_2}{is estimated treatment squared}

\item{e_treat_3}{is estimated treatment cubed}

\item{e_treat_4}{is estimated treatment to the fourth}

\item{degree}{is 1 for linear fit and 2 for quadratic fit}
}
\value{
\code{wtrg_est} returns an object of class "causaldrf",
a list that contains the following components:
\item{param}{the estimated parameters.}
\item{call}{the matched call.}
}
\description{
This method uses weight matrices to
estimate parameters for the quadratic or linear fits.
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data


t_mod_list <- t_mod(treat = T,
              treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
              data = example_data,
              treat_mod = "Normal")

cond_exp_data <- t_mod_list$T_data
full_data <- cbind(example_data, cond_exp_data)

wtrg_list <- wtrg_est(Y = Y,
                      treat = T,
                      covar_formula = ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                      data = example_data,
                      e_treat_1 = full_data$est_treat,
                      e_treat_2 = full_data$est_treat_sq,
                      e_treat_3 = full_data$est_treat_cube,
                      e_treat_4 = full_data$est_treat_quartic,
                      degree = 1)

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
      example_data$Y[sample_index],
      xlab = "T",
      ylab = "Y",
      main = "weighted regression estimate")

abline(wtrg_list$param[1],
        wtrg_list$param[2],
        lty = 2,
        lwd = 2,
        col = "blue")

legend('bottomright',
        "weighted regression estimate",
        lty = 2,
        lwd = 2,
        col = "blue",
        bty='Y',
        cex=1)

rm(example_data, t_mod_list, cond_exp_data, full_data, wtrg_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{aipwee_est}}, \code{\link{wtrg_est}},
   etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

