% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbp_api.R
\name{cbp_api}
\alias{cbp_api}
\title{Core function to retrieve data from cBioPortal API.}
\usage{
cbp_api(
  url_path,
  method = NULL,
  token = get_cbioportal_token(),
  body = NULL,
  extra_box = FALSE,
  quiet = TRUE,
  base_url = NULL
)
}
\arguments{
\item{url_path}{The url path for API call}

\item{method}{Which API method to use. Must be "get" or "post". Default is "get".}

\item{token}{Authentication token, if needed. Default is \code{get_cbioportal_token()}}

\item{body}{Arguments passed to API call (e.g. sample ID or gene IDs)}

\item{extra_box}{Some functions require an additional list() wrapping around body idk why}

\item{quiet}{Returns queried URL. Default is TRUE}

\item{base_url}{The database URL to query}
}
\value{
A parsed API response
}
\description{
Core function to retrieve data from cBioPortal API.
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

cbp_api(url_path = "genes/TP53", base_url = "public")
\dontshow{\}) # examplesIf}
}
\keyword{internal}
