% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_study.R
\name{get_fusions_by_study}
\alias{get_fusions_by_study}
\alias{get_structural_variants_by_study}
\title{Get Fusions By Study}
\usage{
get_fusions_by_study(
  study_id = NULL,
  molecular_profile_id = NULL,
  base_url = NULL
)

get_structural_variants_by_study(
  study_id = NULL,
  molecular_profile_id = NULL,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A study ID to query mutations. If NULL, guesses study ID based
on molecular_profile_id.}

\item{molecular_profile_id}{a molecular profile to query mutations.
If NULL, guesses molecular_profile_id based on study ID.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A dataframe of fusions
}
\description{
Get Fusions By Study
}
\examples{
\dontrun{
# These return the same results
get_fusions_by_study(molecular_profile_id = "prad_msk_2019_structural_variants")

get_structural_variants_by_study(molecular_profile_id =
       "prad_msk_2019_structural_variants")
       }
}
