% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbsopendata.R
\docType{package}
\name{cbsodataR-package}
\alias{cbsodataR}
\alias{cbsodataR-package}
\title{Download all data from Statistics Netherlands / CBS}
\description{
\code{cbsodataR} allows to download all official statistics of Statistics
Netherlands (CBS) into R. For a introduction please visit the
\href{https://edwindj.github.io/cbsodataR/articles/cbsodataR.html}{vignette}:
\code{vignette("cbsodataR", package="cbsodataR")}.
The functions \code{\link[=cbs_get_toc]{cbs_get_toc()}}
and \code{\link[=cbs_get_data]{cbs_get_data()}} should get you going.
}
\section{Catalog function}{

\itemize{
\item \code{\link[=cbs_get_toc]{cbs_get_toc()}}, returns a data.frame with table of contents (toc): the publication
meta data for all available tables
}
}

\section{Data retrieval}{

\itemize{
\item \code{\link[=cbs_get_data]{cbs_get_data()}}, returns the data of a specific opendata/StatLine table
\item \code{\link[=cbs_download_table]{cbs_download_table()}}, saves the data (and metadata) as csv files
into a directory
}
}

\section{Meta data}{

\itemize{
\item \code{\link[=cbs_get_meta]{cbs_get_meta()}}, returns the meta data objects of a specific opendata / StatLine
table .
\item \code{\link[=cbs_add_date_column]{cbs_add_date_column()}}, converts date/period codes into \code{DateTime} objects
in the data set that was downloaded.
\item \code{\link[=cbs_add_label_columns]{cbs_add_label_columns()}}, adds labels to the code columns in the data that
was downloaded.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/edwindj/cbsodataR}
  \item Report bugs at \url{https://github.com/edwindj/cbsodataR/issues}
}

}
\author{
\strong{Maintainer}: Edwin de Jonge \email{edwindjonge@gmail.com}

Other contributors:
\itemize{
  \item Sara Houweling [contributor]
}

}
