% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbs_download_data.R
\name{cbs_download_data}
\alias{cbs_download_data}
\title{Gets all data from a cbs table.}
\usage{
cbs_download_data(
  id,
  path = file.path(id, "data.csv"),
  catalog = "CBS",
  ...,
  select = NULL,
  typed = TRUE,
  verbose = FALSE,
  show_progress = interactive() && !verbose,
  base_url = getOption("cbsodataR.base_url", BASE_URL)
)
}
\arguments{
\item{id}{of cbs open data table}

\item{path}{of data file, defaults to "id/data.csv"}

\item{catalog}{catalog id, can be retrieved with \code{\link[=cbs_get_datasets]{cbs_get_datasets()}}}

\item{...}{optional filter statements to select rows of the data,}

\item{select}{optional names of columns to be returned.}

\item{typed}{Should the data automatically be converted into integer and numeric?}

\item{verbose}{show the underlying downloading of the data}

\item{show_progress}{show a progress bar while downloading.}

\item{base_url}{optionally specify a different server. Useful for
third party data services implementing the same protocol.}
}
\description{
Gets all data via bulk download. \code{cbs_download_data} dumps the data in
(international) csv format.
}
\seealso{
Other download: 
\code{\link{cbs_download_meta}()},
\code{\link{cbs_download_table}()}

Other data retrieval: 
\code{\link{cbs_add_date_column}()},
\code{\link{cbs_add_label_columns}()},
\code{\link{cbs_add_unit_column}()},
\code{\link{cbs_extract_table_id}()},
\code{\link{cbs_get_data}()},
\code{\link{cbs_get_data_from_link}()}
}
\concept{data retrieval}
\concept{download}
