% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caching.R
\name{cc_cache}
\alias{cc_cache}
\alias{cc_cache_list}
\alias{cc_cache_delete}
\alias{cc_cache_delete_all}
\alias{cc_cache_details}
\title{Manage cached CCAFS files}
\usage{
cc_cache_list()

cc_cache_delete(files, force = TRUE)

cc_cache_delete_all(force = TRUE)

cc_cache_details(files = NULL)
}
\arguments{
\item{files}{(character) one or more complete file names}

\item{force}{(logical) Should files be force deleted? Default: \code{TRUE}}
}
\description{
Manage cached CCAFS files
}
\details{
\code{cache_delete} only accepts 1 file name, while
\code{cache_delete_all} doesn't accept any names, but deletes all files.
For deleting many specific files,
use \code{cache_delete} in a \code{\link{lapply}} type call

We cache using \code{\link[rappdirs]{user_cache_dir}}, find your
cache folder by executing \code{rappdirs::user_cache_dir("ccafs")}
}
\section{Functions}{

\itemize{
 \item \code{cc_cache_list()} returns a character vector of full path file
 names
 \item \code{cc_cache_delete()} deletes one or more files, returns nothing
 \item \code{cc_cache_delete_all()} delete all files, returns nothing
 \item \code{cc_cache_details()} prints file name and file size for each
 file, supply with one or more files, or no files (and get details for
 all available)
}
}

\examples{
\dontrun{
# list files in cache
cc_cache_list()

# List info for single files
cc_cache_details(files = cc_cache_list()[1])
cc_cache_details(files = cc_cache_list()[2])

# List info for all files
cc_cache_details()

# delete files by name in cache
# cc_cache_delete(files = cc_cache_list()[1])

# delete all files in cache
# cc_cache_delete_all()
}
}
