% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_cont.R
\name{perm_cont}
\alias{perm_cont}
\title{Permutation procedure when Z is continuous}
\usage{
perm_cont(Y, X, Z)
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expressions from \code{n} samples (or cells).}

\item{X}{a numeric or factor vector of size \code{n}
containing the variable to be tested (the condition to be tested).}

\item{Z}{a numeric vector of size \code{n}
containing the covariate. Multiple variables are not allowed.}
}
\value{
\code{X_star} a vector of permuted \code{X}.
}
\description{
Permutation procedure when Z is continuous
}
\examples{

if(interactive()){
X <- rbinom(n=100, size = 1, prob = 0.5)
Z <- rnorm(100,0,1)
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
res <- perm_cont(Y,X,Z)}
}
