% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_perm.R
\name{test_perm}
\alias{test_perm}
\title{Permutation test}
\usage{
test_perm(
  Y,
  X,
  Z = NULL,
  n_perm = 100,
  parallel = FALSE,
  n_cpus = NULL,
  space_y = FALSE,
  number_y = length(Y)
)
}
\arguments{
\item{Y}{a numeric vector of size \code{n} containing the
preprocessed expression for a given gene from \code{n} samples (or cells).}

\item{X}{a data frame of numeric or factor vector(s) of size \code{n}
containing the variable(s) to be tested (the condition(s)). Multiple variables are not allowed.}

\item{Z}{a data frame of numeric or factor vector(s) 
of size \code{n} containing the covariate(s). Multiple variables are not allowed.}

\item{n_perm}{the number of permutations. Default is \code{100}.}

\item{parallel}{a logical flag indicating whether parallel computation
should be enabled. Default is \code{TRUE}.}

\item{n_cpus}{an integer indicating the number of cores to be used when
\code{parallel} is \code{TRUE}.
Default is \code{parallel::detectCores() - 1}.}

\item{space_y}{a logical flag indicating whether the y thresholds are spaced. 
When \code{space_y} is \code{TRUE}, a regular sequence between the minimum and 
the maximum of the observations is used. Default is \code{FALSE}.}

\item{number_y}{an integer value indicating the number of y thresholds (and therefore
the number of regressions) to perform the test. Default is \code{length(Y)}.}
}
\value{
A data frame with the following elements:
\itemize{
  \item \code{score} contains the test statistic for a given gene.
  \item \code{raw_pval} contains the raw p-values for a given gene computed from \code{n_perm} permutations.
}
}
\description{
Permutation test
}
\examples{

if(interactive()){
X <- as.factor(rbinom(n=100, size = 1, prob = 0.5))
Y <- ((X==1)*rnorm(n = 50,0,1)) + ((X==0)*rnorm(n = 50,0.5,1))
res_perm <- test_perm(Y,data.frame(X=X),n_perm=10)}
}
