% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa.R, R/imports.R
\docType{package}
\name{cfa}
\alias{cfa}
\alias{cfa-package}
\title{cfa}
\usage{
cfa(formla, xformla = NULL, tvals, yvals, data, method = "dr",
  link = "logit", tau = seq(0.01, 0.99, 0.01), condDistobj = NULL,
  se = TRUE, iters = 100, cl = 1)
}
\arguments{
\item{formla}{a formula y ~ treatment}

\item{xformla}{one sided formula for x variables to include, e.g. ~x1 + x2}

\item{tvals}{the values of the "treatment" to compute parameters of
interest for}

\item{yvals}{the values to compute the counterfactual distribution for}

\item{data}{the data.frame where y, t, and x are}

\item{method}{either "dr" or "qr" for distribution regression or quantile regression}

\item{link}{if using distribution regression, any link function that works with the binomial family (e.g. logit (the default), probit, cloglog)}

\item{tau}{if using quantile regression, which values of tau to estimate
the conditional quantiles}

\item{condDistobj}{optional conditional distribution  object that has
been previously  computed}

\item{se}{whether or not to compute standard errors using the bootstrap}

\item{iters}{how many bootstrap iterations to use}

\item{cl}{how many clusters to use for parallel computation of standard
errors}
}
\value{
CFA object
}
\description{
compute counterfactuals using distribution regression
 with a continuous treatment
}
\examples{
data(igm)
tvals <- seq(10,12,length.out=8)
yvals <- seq(quantile(igm$lcfincome, .05), quantile(igm$lcfincome, .95), length.out=50)
## This line doesn't adjust for any covariates
cfa(lcfincome ~ lfincome, tvals=tvals, yvals=yvals, data=igm,
 se=FALSE)

## This line adjusts for differences in education
cfa(lcfincome ~ lfincome, ~HEDUC, tvals=tvals, yvals=yvals, data=igm,
 se=FALSE)

}
