#' variables.csv
#'
#' This dataset lists all the variables that are present in cchsflow.
#'
#' See the below link for more details about how the worksheet is structured
#' \url{https://big-life-lab.github.io/cchsflow/articles/variables_sheet.html}
#'
#'
#' @name variables
#' @aliases variables
#' @docType data
#' @return \item{variables}{a data frame}
#'
#' @keywords datasets
#' @examples
#' data(variables)
#' str(variables)
NULL

#' variable_details.csv
#'
#' This dataset provides details on how variables are recoded in cchsflow.
#'
#' See the below link for more details about how the worksheet is structured
#' \url{https://big-life-lab.github.io/cchsflow/articles/variable_details.html}
#'
#' @name variable_details
#' @aliases variable_details
#' @docType data
#' @return \item{variable_details}{a data frame}
#'
#' @keywords datasets
#' @examples
#' data(variable_details)
#' str(variable_details)
NULL

#' 2001 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2001 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2001-c1-1-general-file
#'
#' DDI: \url{https://osf.io/jtd9h/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2001_p
#' @aliases cchs2001_p
#' @docType data
#' @return \item{cchs2001_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=3359}
#'
#' @keywords datasets
#' @examples
#' data(cchs2001_p)
#' str(cchs2001_p)
NULL

#' 2003 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2003 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2003-c2-1-General File
#'
#' DDI: \url{https://osf.io/nzq37/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2003_p
#' @aliases cchs2003_p
#' @docType data
#' @return \item{cchs2003_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=4995}
#'
#' @keywords datasets
#' @examples
#' data(cchs2003_p)
#' str(cchs2003_p)
NULL

#' 2005 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2005 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2005-c3-1-main-file
#'
#' DDI: \url{https://osf.io/35mhq/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2005_p
#' @aliases cchs2005_p
#' @docType data
#' @return \item{cchs2005_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=22642}
#'
#' @keywords datasets
#' @examples
#' data(cchs2005_p)
#' str(cchs2005_p)
NULL

#' 2007-2008 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2007-2008 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-E-2007-2008-AnnualComponent
#'
#' DDI: \url{https://osf.io/emzsp/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2007_2008_p
#' @aliases cchs2007_2008_p
#' @docType data
#' @return \item{cchs2007_2008_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=29539}
#'
#' @keywords datasets
#' @examples
#' data(cchs2007_2008_p)
#' str(cchs2007_2008_p)
NULL

#' 2009-2010 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2009-2010 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: CCHS-82M0013-E-2009-2010-Annualcomponent
#'
#' DDI: \url{https://osf.io/ynzpe/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2009_2010_p
#' @aliases cchs2009_2010_p
#' @docType data
#' @return \item{cchs2009_2010_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=67251}
#'
#' @keywords datasets
#' @examples
#' data(cchs2009_2010_p)
#' str(cchs2009_2010_p)
NULL

#' 2010 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2010 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#' 
#' \strong{NOTE:} this subset of respondents may also be in the 2009-2010 PUMF
#' subset. Please see the "CCHS datasets that overlap each other" article to see
#' how the two datasets contain overlap.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: CCHS-82M0013-E-2010-AnnualComponent
#'
#' DDI: \url{https://osf.io/7stpz/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2010_p
#' @aliases cchs2010_p
#' @docType data
#' @return \item{cchs2010_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=81424}
#'
#' @keywords datasets
#' @examples
#' data(cchs2010_p)
#' str(cchs2010_p)
NULL

#' 2011-2012 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2011-2012 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2011-2012-Annual-component
#'
#' DDI: \url{https://osf.io/zk2vw/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2011_2012_p
#' @aliases cchs2011_2012_p
#' @docType data
#' @return \item{cchs2011_2012_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=114112}
#'
#' @keywords datasets
#' @examples
#' data(cchs2011_2012_p)
#' str(cchs2011_2012_p)
NULL

#' 2012 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2012 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#' 
#' \strong{NOTE:} this subset of respondents may also be in the 2011-2012 PUMF
#' subset. Please see the "CCHS datasets that overlap each other" article to see
#' how the two datasets contain overlap.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2012-Annual-component
#'
#' DDI: \url{https://osf.io/sbem8/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2012_p
#' @aliases cchs2012_p
#' @docType data
#' @return \item{cchs2012_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=135927}
#'
#' @keywords datasets
#' @examples
#' data(cchs2012_p)
#' str(cchs2012_p)
NULL

#' 2013-2014 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2013-2014 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2013-2014-Annual-component
#'
#' DDI: \url{https://osf.io/gy25d/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2013_2014_p
#' @aliases cchs2013_2014_p
#' @docType data
#' @return \item{cchs2013_2014_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=144170}
#'
#' @keywords datasets
#' @examples
#' data(cchs2013_2014_p)
#' str(cchs2013_2014_p)
NULL

#' 2014 CCHS PUMF subset data (200 respondents)
#'
#' This is a subset of 200 observations from the 2014 cycle of the Canadian
#' Community Health Survey (CCHS) Public Use Microdata file (PUMF) dataset.
#' The CCHS survey is conducted by Statistics Canada.
#' 
#' \strong{NOTE:} this subset of respondents may also be in the 2013-2014 PUMF
#' subset. Please see the "CCHS datasets that overlap each other" article to see
#' how the two datasets contain overlap.
#'
#' See \href{https://www.statcan.gc.ca/eng/reference/licence}{here} for the open
#' license. Source from Statistics Canada, Canadian Community Health Survey 
#' PUMF, accessed Jan 2020. Reproduced and distributed on an "as is" basis with 
#' the permission of Statistics Canada.
#'
#' Long name: cchs-82M0013-E-2014-Annual-component
#'
#' DDI: \url{https://osf.io/tbmdn/}
#'
#' Additional documentation (PDFs): \url{https://osf.io/hkuy3/}
#'
#' @name cchs2014_p
#' @aliases cchs2014_p
#' @docType data
#' @return \item{cchs2014_p}{a data frame}
#'
#' @source
#'  \url{https://www23.statcan.gc.ca/imdb/p2SV.pl?Function=getSurvey&Id=164081}
#'
#' @keywords datasets
#' @examples
#' data(cchs2014_p)
#' str(cchs2014_p)
NULL