% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polarizability.R
\name{alpha_ellipsoid}
\alias{alpha_ellipsoid}
\title{alpha_ellipsoid}
\usage{
alpha_ellipsoid(sizes, material, medium)
}
\arguments{
\item{sizes}{matrix of cluster sizes in nm}

\item{material}{data.frame with wavelength and epsilon}

\item{medium}{refractive index of surrounding medium}
}
\value{
matrix of polarisability
}
\description{
Principal polarisability components for an ellipsoidal particle
}
\details{
This long-wavelength polarisability approximation uses the Kuwata prescription


The Kuwata prescription includes semi-empirical terms of radiative correction and dynamic depolarisation to better match the fully retarded dipolar response in a reasonable range of (subwavelength) sizes and aspect ratios.
}
\author{
baptiste Auguie
}
\references{
Kuwata et al. Resonant light scattering from metal nanoparticles: Practical analysis beyond Rayleigh approximation Appl. Phys. Lett. 83, 22 (2003)
}
\seealso{
Other user_level polarisability: \code{\link{alpha_bare}},
  \code{\link{alpha_dye}}
}

