% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrum_functions.r
\name{spectrum_oa}
\alias{spectrum_oa}
\title{spectrum_oa}
\usage{
spectrum_oa(cluster, material, medium = 1.33, quadrature = c("gl", "qmc",
  "random", "cheap"), Nq = 100, iterative = FALSE, precision = 0.001,
  Qmax = 10000, dN = Nq, method = c("solve", "cg", "oos"), Nsca = 50,
  maxiter = 30, tol = 1e-04, progress = FALSE, verbose = TRUE)
}
\arguments{
\item{cluster}{cluster (list)}

\item{material}{material}

\item{medium}{refractive index medium}

\item{quadrature}{quadrature method, using either Gauss Legendre quadrature (default), Quasi Monte Carlo, random, or "cheap" (3 Axes)}

\item{Nq}{number of integration points}

\item{iterative}{logical, increase N until convergence (QMC only)}

\item{precision}{relative diff between two runs (QMC only)}

\item{Qmax}{maximum N if convergence not attained (QMC only)}

\item{dN}{iterative increase in N (QMC only)}

\item{method}{linear system (solve), conjugate-gradient (cg), or order-of-scattering (oos)}

\item{Nsca}{quadrature points for scattering cross-section}

\item{maxiter}{integer termination of iterative solver}

\item{tol}{double, tolerance of iterative solver}

\item{progress}{print progress lines}

\item{verbose}{display messages}
}
\description{
Orientation-averaged spectrum
}
\details{
OA spectrum
}
\author{
baptiste Auguie
}
\references{
Y. Okada, Efficient numerical orientation quadrature of light scattering properties
with a quasi-Monte-Carlo method, Journal of Quantitative Spectroscopy and Radiative Transfer, Volume 109, Issue 9, June 2008, Pages 1719-1742.
}

