% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DefOps.R, R/LocalOps.R, R/relops.R
\name{blocks_to_rowrecs}
\alias{blocks_to_rowrecs}
\alias{blocks_to_rowrecs.default}
\alias{blocks_to_rowrecs.relop}
\title{Map sets rows to columns (takes a \code{data.frame}).}
\usage{
blocks_to_rowrecs(tallTable, keyColumns, controlTable, ...,
  columnsToCopy = NULL, checkNames = TRUE, checkKeys = TRUE,
  strict = FALSE, controlTableKeys = colnames(controlTable)[[1]],
  tmp_name_source = wrapr::mk_tmp_name_source("bltrr"),
  temporary = TRUE)

\method{blocks_to_rowrecs}{default}(tallTable, keyColumns, controlTable,
  ..., columnsToCopy = NULL, checkNames = TRUE, checkKeys = TRUE,
  strict = FALSE, controlTableKeys = colnames(controlTable)[[1]],
  tmp_name_source = wrapr::mk_tmp_name_source("btrd"),
  temporary = TRUE)

\method{blocks_to_rowrecs}{relop}(tallTable, keyColumns, controlTable, ...,
  columnsToCopy = NULL, checkNames = TRUE, checkKeys = FALSE,
  strict = FALSE, controlTableKeys = colnames(controlTable)[[1]],
  tmp_name_source = wrapr::mk_tmp_name_source("bltrr"),
  temporary = TRUE)
}
\arguments{
\item{tallTable}{data.frame containing data to be mapped (in-memory data.frame).}

\item{keyColumns}{character vector of column defining row groups}

\item{controlTable}{table specifying mapping (local data frame)}

\item{...}{force later arguments to be by name.}

\item{columnsToCopy}{character, extra columns to copy.}

\item{checkNames}{logical, if TRUE check names.}

\item{checkKeys}{logical, if TRUE check keyColumns uniquely identify blocks (required).}

\item{strict}{logical, if TRUE check control table name forms}

\item{controlTableKeys}{character, which column names of the control table are considered to be keys.}

\item{tmp_name_source}{a tempNameGenerator from cdata::mk_tmp_name_source()}

\item{temporary}{logical, if TRUE use temporary tables}
}
\value{
wide table built by mapping key-grouped tallTable rows to one row per group
}
\description{
Transform data facts from rows into additional columns using controlTable.
}
\details{
This is using the theory of "fluid data"n
(\url{https://github.com/WinVector/cdata}), which includes the
principle that each data cell has coordinates independent of the
storage details and storage detail dependent coordinates (usually
row-id, column-id, and group-id) can be re-derived at will (the
other principle is that there may not be "one true preferred data
shape" and many re-shapings of data may be needed to match data to
different algorithms and methods).

The controlTable defines the names of each data element in the two notations:
the notation of the tall table (which is row oriented)
and the notation of the wide table (which is column oriented).
controlTable[ , 1] (the group label) cross colnames(controlTable)
(the column labels) are names of data cells in the long form.
controlTable[ , 2:ncol(controlTable)] (column labels)
are names of data cells in the wide form.
To get behavior similar to tidyr::gather/spread one builds the control table
by running an appropriate query over the data.

Some discussion and examples can be found here:
\url{https://winvector.github.io/FluidData/FluidData.html} and
here \url{https://github.com/WinVector/cdata}.
}
\examples{

  # pivot example
  d <- data.frame(meas = c('AUC', 'R2'),
                  val = c(0.6, 0.2))

  cT <- build_pivot_control(d,
                            columnToTakeKeysFrom= 'meas',
                            columnToTakeValuesFrom= 'val')
  blocks_to_rowrecs(d,
                    keyColumns = NULL,
                    controlTable = cT)


d <- data.frame(meas = c('AUC', 'R2'),
                val = c(0.6, 0.2))
cT <- build_pivot_control(
  d,
  columnToTakeKeysFrom= 'meas',
  columnToTakeValuesFrom= 'val')

ops <- rquery::local_td(d) \%.>\%
  blocks_to_rowrecs(.,
                    keyColumns = NULL,
                    controlTable = cT)
cat(format(ops))

if(requireNamespace("rqdatatable", quietly = TRUE)) {
  library("rqdatatable")
  d \%.>\%
    ops \%.>\%
    print(.)
}

if(requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  DBI::dbWriteTable(db,
                    'd',
                    d,
                    overwrite = TRUE,
                    temporary = TRUE)
  db \%.>\%
    ops \%.>\%
    print(.)
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{build_pivot_control}}, \code{\link{rowrecs_to_blocks}}
}
