% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrMethod.R
\name{summary.cdfqr}
\alias{coef.cdfqr}
\alias{deviance.cdfqr}
\alias{formula.cdfqr}
\alias{logLik.cdfqr}
\alias{print.cdfqr}
\alias{summary.cdfqr}
\alias{update.cdfqr}
\alias{vcov.cdfqr}
\title{S3 Methods for getting output from fitted cdfqr Objects.}
\usage{
\method{summary}{cdfqr}(object, ...)

\method{print}{cdfqr}(x, digits = max(3, getOption("digits") - 3), ...)

\method{logLik}{cdfqr}(object, ...)

\method{deviance}{cdfqr}(object, ...)

\method{coef}{cdfqr}(object, type = c("full", "mean", "sigma"), ...)

\method{vcov}{cdfqr}(object, type = c("full", "mean", "sigma"), ...)

\method{update}{cdfqr}(object, formula., ..., evaluate = TRUE)

\method{formula}{cdfqr}(x, ...)
}
\arguments{
\item{object}{The fitted cdfqr model.}

\item{...}{Pass onto other functions or currently ignored}

\item{x}{The fitted cdfqr model.}

\item{digits}{Number of digits to be retained in printed output.}

\item{type}{The parts of coefficients or variance-covariance matrix to be extracted.}

\item{formula.}{Changes to the formula. See \code{\link[Formula]{update.Formula}} for details.}

\item{evaluate}{If true evaluate the new updated model else return the call for the new model.}
}
\description{
Give the Gradient Function for CDF-Quantile Distribution Modles
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2','t2', data = JurorData)

summary(fit)
print(fit)
logLik(fit)
coef(fit)
deviance(fit)
vcov(fit)

#Update the model
fit2 <- update(fit, crc99 ~ vert*confl | confl)
summary(fit2)

}

