% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrDfFT.R
\name{cdfft}
\alias{cdfft}
\alias{pdfft}
\alias{qqft}
\alias{rqft}
\title{The Family of Finite-Tailed Distributions}
\usage{
cdfft(q, sigma, theta, fd, sd, mu = NULL, inner = TRUE, version)

pdfft(y, sigma, theta, fd, sd, mu = NULL, inner = TRUE, version)

qqft(p, sigma, theta, fd, sd, mu = NULL, inner = TRUE, version)

rqft(n, sigma, theta, fd, sd, mu = NULL, inner = TRUE, version)
}
\arguments{
\item{q}{vector of quantiles.}

\item{sigma}{vector of standard deviations.}

\item{theta}{vector of skewness.}

\item{fd}{A string that specifies the parent distribution. At the moment, only "arcsinh", "cauchit" and "t2" can be used. See details.}

\item{sd}{A string that specifies the child distribution. At the moment, only "arcsinh", "cauchy" and "t2" can be used. See details.}

\item{mu}{vector of means if 3-parameter case is used.}

\item{inner}{A logic value that indicates if the inner (\code{inner = TRUE}) case or outer (\code{inner = FALSE}) will be used.}

\item{version}{A string indicates that which version will be used. "V" is the tilt parameter function while "W" indicates the Jones Pewsey transformation.}

\item{y}{vector of quantiles.}

\item{p}{vector of probabilities.}

\item{n}{Number of random samples.}
}
\value{
\code{pdfft} gives the density, \code{rqft} generates random variate, \code{qqft} gives the quantile function, and \code{cdfft} gives the cumulative density of specified distribution.
}
\description{
Density function, distribution function, quantile function, and random generation of variates for a specified cdf-quantile distribution.
}
