% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfquantregHurdle.R
\name{cdfquantregH}
\alias{cdfquantregH}
\title{Zero/One inflated CDF-Quantile Probability Distributions}
\usage{
cdfquantregH(
  formula,
  zero.fo = ~1,
  one.fo = ~1,
  fd = NULL,
  sd = NULL,
  data,
  family = NULL,
  type = "ZI",
  start = NULL,
  control = cdfqr.control(...),
  ...
)
}
\arguments{
\item{formula}{A formula object, with the dependent variable (DV) on the left of an ~ operator, and predictors on the right. For the part on the right of '~', the specification of the location and dispersion submodels can be separated by '|'. So \code{y ~ X1 | X2} specifies that the DV is \code{y}, \code{X1} is the predictor in the location submodel, and \code{X2} is the predictor in the dispersion submodel.}

\item{zero.fo}{A formula object to indicate the predictors for the zero component, only input as \code{~ predictors}}

\item{one.fo}{A formula object to indicate the predictors for the one component, only input as \code{~ predictors}}

\item{fd}{A string that specifies the parent distribution.}

\item{sd}{A string that specifies the child distribution.}

\item{data}{The data in a data.frame format}

\item{family}{If `fd` and `sd` are not provided, the name of a member of the family of distributions can be provided (See \code{\link{cdfqrFamily}} for details of family functions)}

\item{type}{A string variable to indicate whether the model is zero-inflated \code{`ZI`}, or one-inflated \code{`OI`}, or zero-one inflated \code{`ZO`}.}

\item{start}{The starting values for model fitting. If not provided, default values will be used.}

\item{control}{Control optimization parameters  (See \code{\link{cdfqr.control}}))}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{cdfqrH} will be returned. Generic functions such as \link{summary},\link{print} (e.g.,  \link{print.cdfqr}) and \link{coef} can be used to extract output (see \link{summary.cdfqr} for more details about the generic functions that can be used).
Class of object is a list with the following output:
 \describe{
  \item{coefficients}{A named vector of coefficients.}
  \item{residuals}{Raw residuals, the difference between the fitted values and the data.}
  \item{fitted}{The fitted values, including full model fitted values, fitted values for the mean component, and fitted values for the dispersion component.}
  \item{vcov}{The variance-covariance matrix of the coefficient estimates.}
  \item{AIC, BIC}{Akaike's Information Criterion and Bayesian Information Criterion.}
}
}
\description{
\code{cdfquantregH} is the a function to fit a Zero/One inflated CDF-Quantile regression with a variety of distributions .
}
\details{
The cdfquantreg function fits a quantile regression model with a distributions from the cdf-quantile family selected by the user (Smithson and Shou, 2015). The model is specified in a two-part formula, one part containing the predictors of the location parameter, and the second part containing the predictors of the dispersion parameter.  The models are fitted in two stages, the first of which uses the Nelder-Mead algorithm and the second of which takes the estimates from the first stage and applies the BFGS algorithm to refine the estimates.
}
\examples{
data(cdfqrExampleData)
# For one-inflated model
ipcc_high <- subset(IPCC, mid == 1 & high == 1 & prob!=0)
fit <- cdfquantregH(prob ~ valence | valence,one.fo = ~valence,
  fd ='t2',sd ='t2', type = "OI", data = ipcc_high)

summary(fit)

# For zero-inflated model
ipcc_low <- subset(IPCC, mid == 0 & high == 0 & prob!=1)
fit <- cdfquantregH(prob ~ valence | valence, zero.fo = ~valence,
  fd ='t2',sd ='t2', type = "ZI", data = ipcc_low)
 
 
# For zero &one-inflated model
ipcc_mid <- subset(IPCC, mid == 1 & high == 0)
fit <- cdfquantregH(prob ~ valence | valence, zero.fo = ~valence,
  one.fo = ~valence,
  fd ='t2',sd ='t2', type = "ZO", data = ipcc_mid)
 
  
}
