% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-set-transformations.R
\name{repairGaps}
\alias{repairGaps}
\title{Process Tracks Containing Gaps}
\usage{
repairGaps(x, how = "split", tol = 0.05, split.min.length = 2)
}
\arguments{
\item{x}{the input tracks object.}

\item{how}{string specifying what do with tracks that contain gaps. Possible
  values are:
\itemize{
 \item{"drop":}{ the simplest option -- discard all tracks that contain gaps.}
 \item{"split":}{ split tracks around the gaps, e.g. a track for which the step
 between the 3rd and 4th positions is too long or too short is split into one
 track corresponding to positions 1 to 3 and another track corresponding to
 position 3 onwards.}
 \item{"interpolate":}{ approximate the track positions using linear
 interpolation (see \code{\link{interpolateTrack}}). The result is a tracks
 object with constant step durations.
 }
}}

\item{tol}{nonnegative number specifying by which fraction each step may deviate
from the average step duration without being considered a gap. For instance, if
the average step duration (see \code{\link{timeStep}}) is 100 seconds and \code{tol}
is 0.05 (the default), then step durations between 95 and 105 seconds (both inclusive)
are not considered gaps. This option is ignored for \code{how="interpolate"}.}

\item{split.min.length}{nonnegative integer. For \code{how="split"}, this
discards all resulting tracks shorter than
this many positions.}
}
\value{
A \code{\link{tracks}} object with gaps fixed according to the chosen method.
}
\description{
Many common motility analyses, such as mean square displacement plots, assume that
object positions are recorded at constant time intervals. For some application domains,
such as intravital imaging, this may not always be the case. This function can be
used to pre-process data imaged at nonconstant intervals, provided the deviations are
not too extreme.
}
\examples{
## The Neutrophil data are imaged at rather nonconstant intervals
print( length( Neutrophils ) )
print( length( repairGaps( Neutrophils, tol=0.01 ) ) )

}
