% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getces.R
\name{get_ces}
\alias{get_ces}
\title{Create a dataframe object for a CES survey.}
\usage{
get_ces(srvy, pos = 1)
}
\arguments{
\item{srvy}{A CES survey code call. See \emph{Survey Code Calls} below.
\code{srvy} value must be a character string.}

\item{pos}{Environment assignment. Defaults to 1, which is an assignment to the global environment.}
}
\value{
The called \code{srvy} at the designated environment position \code{pos}.
Default environment position is set to be the global environment.
}
\description{
\code{get_ces()} creates a dataframe object for a requested Canadian Election Study
survey using an associated survey code to call and download
the survey dataset. On creation of the data object, prints out the associated citation for use with
the requested dataset and a link to the original location of the data file.
}
\details{
\subsection{Datasets}{

Datasets are loaded using .dta, .sav, or .tab file types. See \emph{File Types} below for a list of included
CES datasets and their file type.
To quickly convert a dataset's values to factor type use
\code{labelled::to_factor()} on the dataset.
}

\subsection{Survey Code Calls}{
\itemize{
\item \code{ces2019_web} calls 2019 CES online survey dataset.
\item \code{ces2019_phone} calls 2019 CES phone survey dataset.
\item \code{ces2015_web} calls 2015 CES online survey dataset.
\item \code{ces2015_phone} calls 2015 CES phone survey dataset.
\item \code{ces2015_combo} calls 2015 CES combined (online/phone) dataset.
\item \code{ces2011} calls 2011 CES survey dataset.
\item \code{ces2008} calls 2008 CES survey dataset.
\item \code{ces2004} calls 2004 CES survey dataset.
\item \code{ces0411} calls 2004-2011 CES survey dataset.
\item \code{ces0406} calls 2004-2006 CES survey dataset.
\item \code{ces2000} calls 2000 CES survey dataset.
\item \code{ces1997} calls 1997 CES survey dataset.
\item \code{ces1993} calls 1993 CES survey dataset.
\item \code{ces1988} calls 1988 CES survey dataset.
\item \code{ces1984} calls 1984 CES survey dataset.
\item \code{ces1974} calls 1974 CES survey dataset.
\item \code{ces7480} calls 1974-1980 CES survey dataset.
\item \code{ces72_jnjl} calls 1972 June-July CES survey dataset.
\item \code{ces72_sep} calls 1972 September CES survey dataset.
\item \code{ces72_nov} calls 1972 November CES survey dataset.
\item \code{ces1968} calls 1968 CES survey dataset.
\item \code{ces1965} calls 1965 CES survey dataset.
}
}

\subsection{File Types}{
\itemize{
\item CES 2019 online survey. Loaded as a .dta file type.
\item CES 2019 phone survey. Loaded as a .tab file type.
\item CES 2015 online survey. Loaded as a .dta file type.
\item CES 2015 phone survey. Loaded as a .dta file type.
\item CES 2015 combined survey. Loaded as a .dta file type.
\item CES 2011 survey. Loaded as a .dta file type.
\item CES 2008 survey. Loaded as a .sav file type.
\item CES 2004 survey. Loaded as a .sav file type.
\item CES 2004-2011 surveys. Loaded as a .dta file type.
\item CES 2004-2006 surveys. Loaded as a .sav file type.
\item CES 2000 survey. Loaded as a .sav file type.
\item CES 1997 survey. Loaded as a. sav file type.
\item CES 1993 survey. Loaded as a .sav file type.
\item CES 1988 survey. Loaded as a .sav file type.
\item CES 1974 survey. Loaded as a .sav file type.
\item CES 1974-1980 surveys. Loaded as a .sav file type.
\item CES 1972 June-July surveys. Loaded as a .sav file type.
\item CES 1972 September survey. Loaded as a .sav file type.
\item CES 1972 November survey. Loaded as a .sav file type.
\item CES 1968 survey. Loaded as a .sav file type.
\item CES 1965 survey. Loaded as a .sav file type.
}
}

\subsection{Incorrect/Repeated Code Calls}{

Incorrect (a non-existent survey code) will stop the function process and return an associated error message.
Repeated code calls will load in the raw version of the requested table.
}

\subsection{Extra Notes}{

Due to the naming of the columns in the 1965 and 1968 datasets it is recommended
to download the associated codebook for the requested dataset.
}
}
\examples{
\dontrun{
# call the 2019 CES online survey
get_ces("ces2019_web")

# convert variables to factor
labelled::to_factor(ces2019_web)

# preview dataset
head(ces2019_web)
}
}
\seealso{
\code{get_cescodes()} function help.
}
