% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{parm}
\alias{parm}
\title{Add Parameter}
\usage{
parm(value, name)
}
\arguments{
\item{value}{numeric vector or array, value of the node (optional).}

\item{name}{character scalar, name of the node (optional). In case \code{name} is missing, the node is tried to be added to the graph under an auto-generated name.}
}
\value{
cg.node, parameter.
}
\description{
Add a parameter node to the active graph.
}
\note{
Parameters are assumed to be subject to some optimization process. Hence, their value might change over time.

The name of the parameter node cannot be 'grad' as this is a reserved word.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a parameter with value 1 and name 'p' to the graph.
parm(1, name = "p")

}
\author{
Ron Triepels
}
