% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{run}
\alias{run}
\title{Evaluate the Graph}
\usage{
run(name, values = list())
}
\arguments{
\item{name}{character scalar, name of the node that is evaluated.}

\item{values}{named list or environment, values that are subsituted for the nodes in the graph.}
}
\value{
environment, the value of node \code{name} including the value of all ancestors of \code{name}.
}
\description{
Evaluate node \code{name} in the active graph.
}
\note{
All nodes required to compute node \code{name} must have a value or their value must be able to be computed at run-time. Nodes can be assigned a value when they are created or by calling method \link[cgraph]{set}. Alternatively, argument \code{values} can be used to substitute values for nodes that do not have a value (e.g. inputs) or to fix their values.

Only those nodes needed to compute node \code{name} are evaluated and their values are returned. Values of operation nodes that are cached by function \link[cgraph]{val} are ignored and re-computed.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add an input.
a <- input(name = "a")

# Square the input (i.e. b = a^2).
b <- cg_pow(a, const(2), name = "b")

# Evaluate b at a = 2.
values <- run(b, list(a = 2))

# Retrieve the value of b.
values$b

}
\author{
Ron Triepels
}
