% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{val}
\alias{val}
\title{Evaluate a Node in the Graph}
\usage{
val(name)
}
\arguments{
\item{name}{character scalar, name of the node that is evaluated.}
}
\value{
R object, the value of the node.
}
\description{
Evaluate node \code{name} in the active graph.
}
\note{
The values of all nodes are cached for performance reasons. Only those nodes needed to compute node \code{name} and that have not yet been retrieved by \link[cgraph]{val} are computed.
}
\examples{
# Initialize a new computational graph.
x <- cgraph$new()

# Add a parameter
a <- parm(20, name = "a")

# Evaluate a
val(a)

}
\author{
Ron Triepels
}
