% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{profile_loglik}
\alias{profile_loglik}
\title{Profile loglikelihood}
\usage{
profile_loglik(object, prof_pars = NULL, prof_vals = NULL,
  init = NULL, type = c("vertical", "cholesky", "spectral", "none"),
  ...)
}
\arguments{
\item{object}{An object of class \code{"chandwich"} returned by
\code{adjust_loglik}.}

\item{prof_pars}{A vector specifying the subset of the (unfixed) parameters
  over which to profile. Can be either a numeric vector, specifying indices
  of the components of the \strong{full} parameter vector, or a character
  vector of parameter names, which must be a subset of those supplied in
  \code{par_names} in the call to \code{\link{adjust_loglik}} that produced
  \code{object}.

  \code{prof_pars} must not have any parameters in common with
  \code{attr(object, "fixed_pars")}.  \code{prof_pars} must not contain
  all of the unfixed parameters, i.e. there is no point in profiling over
  all of the unfixed parameters.}

\item{prof_vals}{A numeric vector.  Values of the parameters in
\code{prof_pars}.  If \code{prof_vals = NULL} then the MLEs stored
in \code{object} of the parameters \code{prof_pars} are used.}

\item{init}{A numeric vector of initial estimates of the values of the
parameters that are not fixed and are not in \code{prof_pars}.
Should have length \code{attr(object, "p_current") - length(prof_pars)}.
If \code{init} is \code{NULL} or is of the wrong length then the
relevant components from the MLE stored in \code{object} are used.}

\item{type}{A character scalar.  The argument \code{type} to the function
returned by \code{\link{adjust_loglik}}, that is, the type of adjustment
made to the independence loglikelihood function.}

\item{...}{Further arguments to be passed to \code{\link[stats]{optim}}.
These may include \code{gr}, \code{method}, \code{lower}, \code{upper}
or \code{control}.}
}
\value{
A numeric vector of length 1.  The value of the profile
  loglikelihood.  The returned object has the attribute \code{"free_pars"}
  giving the optimal values of the parameters that remain after the
  parameters \code{prof_pars} and \code{attr(object, "fixed_pars")} have
  been removed from the full parameter vector.  If there are no such
  parameters, which happens if an attempt is made to profile over
  \emph{all} non-fixed parameters, then this attribute is not present and
  the value returned is calculated using the function \code{object}.
}
\description{
Calculates the profile loglikelihood for a subset of the model parameters.
This function is provided primarily so that it can be called by
\code{\link{conf_intervals}} and \code{\link{conf_region}}.
}
\examples{
# -------------------------- GEV model, owtemps data -----------------------
# ------------ following Section 5.2 of Chandler and Bate (2007) -----------

gev_loglik <- function(pars, data) {
  o_pars <- pars[c(1, 3, 5)] + pars[c(2, 4, 6)]
  w_pars <- pars[c(1, 3, 5)] - pars[c(2, 4, 6)]
  if (o_pars[2] <= 0 | w_pars[2] <= 0) return(-Inf)
  o_data <- data[, "Oxford"]
  w_data <- data[, "Worthing"]
  check <- 1 + o_pars[3] * (o_data - o_pars[1]) / o_pars[2]
  if (any(check <= 0)) return(-Inf)
  check <- 1 + w_pars[3] * (w_data - w_pars[1]) / w_pars[2]
  if (any(check <= 0)) return(-Inf)
  o_loglik <- log_gev(o_data, o_pars[1], o_pars[2], o_pars[3])
  w_loglik <- log_gev(w_data, w_pars[1], w_pars[2], w_pars[3])
  return(o_loglik + w_loglik)
}

# Initial estimates (method of moments for the Gumbel case)
sigma <- as.numeric(sqrt(6 * diag(var(owtemps))) / pi)
mu <- as.numeric(colMeans(owtemps) - 0.57722 * sigma)
init <- c(mean(mu), -diff(mu) / 2, mean(sigma), -diff(sigma) / 2, 0, 0)

# Log-likelihood adjustment of the full model
par_names <- c("mu[0]", "mu[1]", "sigma[0]", "sigma[1]", "xi[0]", "xi[1]")
large <- adjust_loglik(gev_loglik, data = owtemps, init = init,
                       par_names = par_names)

# Profile loglikelihood for xi1, evaluated at xi1 = 0
profile_loglik(large, prof_pars = "xi[1]", prof_vals = 0)

# Model with xi1 fixed at 0
medium <- adjust_loglik(larger = large, fixed_pars = "xi[1]")
# Profile loglikelihood for xi0, evaluated at xi0 = -0.1
profile_loglik(medium, prof_pars = "xi[0]", prof_vals = -0.1)
}
\seealso{
\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood function.

\code{\link{conf_intervals}} for confidence intervals for
  individual parameters.

\code{\link{conf_region}} for a confidence region for
  a pair of parameters.
}
