% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{confint.chandwich}
\alias{confint.chandwich}
\title{Confidence intervals for model parameters}
\usage{
\method{confint}{chandwich}(object, parm, level = 0.95,
  type = c("vertical", "cholesky", "spectral", "none"), ...)
}
\arguments{
\item{object}{An object of class \code{"chandwich"}, returned by
\code{\link{adjust_loglik}}.}

\item{parm}{A vector specifying the (unfixed) parameters for which
  confidence intervals are required.
  If missing, all parameters are included.

  Can be either a numeric vector,
  specifying indices of the components of the \strong{full} parameter
  vector, or a character vector of parameter names, which must be a subset
  of those supplied in \code{par_names} in the call to
  \code{\link{adjust_loglik}} that produced \code{object}.

  \code{which_pars} must not have any parameters in common with
  \code{attr(object, "fixed_pars")}.  \code{which_pars} must not contain
  all of the unfixed parameters, i.e. there is no point in profiling over
  all the unfixed parameters.}

\item{level}{The confidence level required.  A numeric scalar in (0, 1).}

\item{type}{A character scalar.  The argument \code{type} to the function
returned by \code{\link{adjust_loglik}}, that is, the type of adjustment
made to the independence loglikelihood function.}

\item{...}{Further arguments to be passed to \code{\link{conf_intervals}}.}
}
\value{
A matrix with columns giving lower and upper confidence limits for
  each parameter. These will be labelled as (1 - level)/2 and
  1 - (1 - level)/2 in \% (by default 2.5\% and 97.5\%).
  The row names are the names of the model parameters,
  if these are available.
}
\description{
\code{confint} method for objects of class \code{"chandwich"}.
Computes confidence intervals for one or more model parameters based
on an object returned from \code{\link{adjust_loglik}}.
}
\details{
For details see the documentation for the function
  \code{\link{conf_intervals}}, on which \code{confint.chandwich} is based.
}
\examples{
# -------------------------- GEV model, owtemps data -----------------------
# ------------ following Section 5.2 of Chandler and Bate (2007) -----------

gev_loglik <- function(pars, data) {
  o_pars <- pars[c(1, 3, 5)] + pars[c(2, 4, 6)]
  w_pars <- pars[c(1, 3, 5)] - pars[c(2, 4, 6)]
  if (o_pars[2] <= 0 | w_pars[2] <= 0) return(-Inf)
  o_data <- data[, "Oxford"]
  w_data <- data[, "Worthing"]
  check <- 1 + o_pars[3] * (o_data - o_pars[1]) / o_pars[2]
  if (any(check <= 0)) return(-Inf)
  check <- 1 + w_pars[3] * (w_data - w_pars[1]) / w_pars[2]
  if (any(check <= 0)) return(-Inf)
  o_loglik <- log_gev(o_data, o_pars[1], o_pars[2], o_pars[3])
  w_loglik <- log_gev(w_data, w_pars[1], w_pars[2], w_pars[3])
  return(o_loglik + w_loglik)
}

# Initial estimates (method of moments for the Gumbel case)
sigma <- as.numeric(sqrt(6 * diag(var(owtemps))) / pi)
mu <- as.numeric(colMeans(owtemps) - 0.57722 * sigma)
init <- c(mean(mu), -diff(mu) / 2, mean(sigma), -diff(sigma) / 2, 0, 0)

# Log-likelihood adjustment of the full model
par_names <- c("mu[0]", "mu[1]", "sigma[0]", "sigma[1]", "xi[0]", "xi[1]")
large <- adjust_loglik(gev_loglik, data = owtemps, init = init,
                       par_names = par_names)
confint(large)
}
\seealso{
\code{\link{conf_intervals}}.

\code{\link{conf_region}} for a confidence region for
  pairs of parameters.

\code{\link{compare_models}} for an adjusted likelihood ratio test
  of two models.

\code{\link{adjust_loglik}} to adjust a user-supplied
  loglikelihood function.
}
